<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AIAgentController;
use App\Http\Controllers\HealthReportController;
use App\Http\Controllers\GroceryController;
use App\Http\Controllers\MealPlanController;
use App\Http\Controllers\TrainerController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);

Route::middleware('auth:sanctum')->group(function () {
    // User profile
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    // Role management
    Route::post('/assign-role', [AuthController::class, 'assignRole']);
    Route::post('/remove-role', [AuthController::class, 'removeRole']);

    // Health Reports
    // Route::apiResource('health-reports', HealthReportController::class);
    Route::middleware('auth:sanctum')->group(function () {
        Route::get('health-reports', [HealthReportController::class, 'index']);
        Route::post('health-reports', [HealthReportController::class, 'store']);
        Route::get('health-reports/{report:report_id}', [HealthReportController::class, 'show']);
        Route::put('health-reports/{report:report_id}', [HealthReportController::class, 'update']);
        Route::patch('health-reports/{report:report_id}', [HealthReportController::class, 'update']);
        Route::delete('health-reports/{report:report_id}', [HealthReportController::class, 'destroy']);
    });
    // Grocery Management
    Route::middleware('auth:sanctum')->group(function () {
        // Items
        Route::get('grocery/items', [GroceryController::class, 'listItems']);
        Route::post('grocery/items', [GroceryController::class, 'createItem']);
        Route::put('grocery/items/{item}', [GroceryController::class, 'updateItem']);
        
        // Orders
        Route::get('grocery/orders', [GroceryController::class, 'listOrders']);
        Route::post('grocery/orders', [GroceryController::class, 'createOrder']);
        Route::get('grocery/orders/{order}', [GroceryController::class, 'showOrder']);
        Route::patch('grocery/orders/{order}/status', [GroceryController::class, 'updateOrderStatus']);
        Route::post('grocery/orders/{order}/items', [GroceryController::class, 'addItemsToOrder']);
        Route::delete('grocery/orders/{order}/items/{item}', [GroceryController::class, 'removeItemFromOrder']);
    });
    

    // Meal Plans
    // Route::apiResource('meal-plans', MealPlanController::class);
    Route::middleware('auth:sanctum')->group(function () {
        // Fetch all meal plans (filtered based on the user's role)
        Route::get('meal-plans', [MealPlanController::class, 'index']);
        
        // Create a new meal plan
        Route::post('meal-plans', [MealPlanController::class, 'store']);
        
        // View a specific meal plan
        Route::get('meal-plans/{mealPlan}', [MealPlanController::class, 'show']);
        
        // Update a specific meal plan
        Route::put('meal-plans/{mealPlan}', [MealPlanController::class, 'update']);
        
        // Delete a specific meal plan
        Route::delete('meal-plans/{mealPlan}', [MealPlanController::class, 'destroy']);
    });


    // Trainer Management
    Route::prefix('trainers')->group(function () {
        Route::get('/', [TrainerController::class, 'index']);
        Route::post('/', [TrainerController::class, 'store']);
        Route::get('/{trainer}', [TrainerController::class, 'show']);
        Route::put('/{trainer}', [TrainerController::class, 'update']);
        Route::post('/{trainer}/assign', [TrainerController::class, 'assignUser']);
        Route::post('/{trainer}/unassign', [TrainerController::class, 'unassignUser']);
        Route::get('/my/clients', [TrainerController::class, 'myClients']);
    });

    // AI Agent routes
    Route::post('/ai-agent/upload', [AIAgentController::class, 'uploadPhoto']);
    Route::post('/scan-skin', [AIAgentController::class, 'scanSkin']);
});