<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    public function run()
    {
        $roles = [
            [
                'name' => 'Free User',
                'slug' => 'free-user',
                'description' => 'Can only access promo/landing page and promo slides'
            ],
            [
                'name' => 'Origin User',
                'slug' => 'origin-user',
                'description' => 'Paid user with access to profile, AI Agent, reports, and chat'
            ],
            [
                'name' => 'Accelerator User',
                'slug' => 'accelerator-user',
                'description' => 'Paid user with access to profile, AI Agent, reports, and chat'
            ],
            [
                'name' => 'Sovereign User',
                'slug' => 'sovereign-user',
                'description' => 'Paid user with access to profile, AI Agent, reports, and chat'
            ],
            [
                'name' => 'Trainer',
                'slug' => 'trainer',
                'description' => 'Can upload docs, reply to chats, and manage protocols for assigned users'
            ],
            [
                'name' => 'Doctor',
                'slug' => 'doctor',
                'description' => 'Can upload insights and reply to chats for assigned users'
            ],
            [
                'name' => 'Personal Assistant',
                'slug' => 'personal-assistant',
                'description' => 'Can manage grocery lists and mark purchases as complete'
            ],
            [
                'name' => 'Admin',
                'slug' => 'admin',
                'description' => 'Can manage users, trainers, docs, and access chats'
            ],
            [
                'name' => 'Super Admin',
                'slug' => 'super-admin',
                'description' => 'Has full platform access and management capabilities'
            ],
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }
    }
} 