<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('chats', function (Blueprint $table) {
            $table->string('chat_id')->primary();
            $table->string('user_id');
            $table->string('trainer_id')->nullable();
            $table->string('channel');
            $table->json('participants');
            $table->timestamp('created_at');
            $table->timestamp('last_updated')->nullable();
            $table->string('last_message')->nullable();
            $table->string('last_sender_id')->nullable();

            $table->foreign('user_id')->references('uid')->on('users')->onDelete('cascade');
            $table->foreign('trainer_id')->references('trainer_id')->on('trainers')->onDelete('set null');
        });

        Schema::create('messages', function (Blueprint $table) {
            $table->string('message_id')->primary();
            $table->string('chat_id');
            $table->string('sender_id');
            $table->string('sender_role');
            $table->text('content');
            $table->timestamp('timestamp');
            $table->boolean('is_read_by_user')->default(false);
            $table->boolean('is_read_by_trainer')->default(false);
            $table->boolean('is_read_by_support')->default(false);
            $table->json('attachments')->nullable();
            $table->timestamps();

            $table->foreign('chat_id')->references('chat_id')->on('chats')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messages');
        Schema::dropIfExists('chats');
    }
};