<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('grocery_orders', function (Blueprint $table) {
            $table->string('order_id')->primary();
            $table->string('user_id');
            $table->json('list_items');
            $table->decimal('invoice_amount', 8, 2);
            $table->enum('status', ['pending', 'needs_revision', 'approved', 'purchased', 'cancelled']);
            $table->string('pdf_url')->nullable();
            $table->string('uploaded_by');
            $table->string('uploader_role');
            $table->timestamp('uploaded_at');
            $table->text('user_feedback')->nullable();
            $table->timestamp('user_feedback_at')->nullable();
            $table->boolean('user_approved')->default(false);
            $table->timestamp('user_approved_at')->nullable();
            $table->timestamp('purchased_at')->nullable();
            $table->boolean('wallet_deducted')->default(false);
            $table->text('purchase_note')->nullable();
            $table->json('tags')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('uid')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('grocery_orders');
    }
};