<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('trainers', function (Blueprint $table) {
            $table->string('trainer_id')->primary();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->nullable();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('role')->default('trainer');
            $table->string('calendly_url')->nullable();
            $table->string('profile_photo_url_1')->nullable();
            $table->string('profile_photo_url_2')->nullable();
            $table->string('profile_photo_url_3')->nullable();
            $table->json('specialties')->nullable();
            $table->text('training_style')->nullable();
            $table->json('certifications')->nullable();
            $table->json('assigned_user_ids')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('trainers');
    }
};