<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('doctors', function (Blueprint $table) {
            $table->string('doctor_id')->primary();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('role')->default('doctor');
            $table->string('specialty');
            $table->string('calendly_url')->nullable();
            $table->string('profile_photo_url')->nullable();
            $table->json('assigned_user_ids')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('doctors');
    }
};