<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('meal_plans', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('user_id');
            $table->date('week_of');
            $table->string('plan_url');
            $table->string('assigned_by');
            $table->string('nutrition_focus');
            $table->timestamps();

            $table->foreign('user_id')
                ->references('uid')
                ->on('users')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('meal_plans');
    }
}; 