<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('grocery_items', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2)->default(0);
            $table->string('category')->nullable();
            $table->json('nutritional_info')->nullable();
            $table->timestamps();
        });

        Schema::create('grocery_orders', function (Blueprint $table) {
            $table->uuid('order_id')->primary();
            $table->string('user_id');
            $table->decimal('invoice_amount', 10, 2);
            $table->enum('status', ['pending', 'needs_revision', 'approved', 'purchased', 'cancelled'])->default('pending');
            $table->string('pdf_url')->nullable();
            $table->string('uploaded_by');
            $table->string('uploader_role');
            $table->timestamp('uploaded_at');
            $table->text('user_feedback')->nullable();
            $table->timestamp('user_feedback_at')->nullable();
            $table->boolean('user_approved')->default(false);
            $table->timestamp('user_approved_at')->nullable();
            $table->timestamp('purchased_at')->nullable();
            $table->boolean('wallet_deducted')->default(false);
            $table->text('purchase_note')->nullable();
            $table->json('tags')->nullable();
            $table->timestamps();

            $table->foreign('user_id')
                ->references('uid')
                ->on('users')
                ->onDelete('cascade');
        });

        Schema::create('grocery_order_items', function (Blueprint $table) {
            $table->id();
            $table->uuid('order_id');
            $table->uuid('item_id');
            $table->integer('quantity');
            $table->decimal('unit_price', 10, 2);
            $table->timestamps();

            $table->foreign('order_id')
                ->references('order_id')
                ->on('grocery_orders')
                ->onDelete('cascade');
            $table->foreign('item_id')
                ->references('id')
                ->on('grocery_items')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('grocery_order_items');
        Schema::dropIfExists('grocery_orders');
        Schema::dropIfExists('grocery_items');
    }
}; 