<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('health_reports', function (Blueprint $table) {
            $table->uuid('report_id')->primary();
            $table->string('report_name');
            $table->string('report_url');
            $table->timestamp('uploaded_at');
            $table->string('uploaded_by');
            $table->string('uploader_role');
            $table->string('visibility');
            $table->string('report_type');
            $table->text('notes')->nullable();
            $table->string('status')->default('draft');
            $table->timestamp('expires_at')->nullable();
            $table->json('tags')->nullable();
            $table->boolean('viewed_by_user')->default(false);
            $table->string('user_id');
            $table->timestamps();

            $table->foreign('user_id')
                ->references('uid')
                ->on('users')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('health_reports');
    }
}; 