<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->string('uid')->primary();
            $table->string('email')->unique();
            $table->string('name');
            $table->string('password');
            $table->string('address')->nullable();
            $table->string('display_photo_url')->nullable();
            $table->enum('membership_tier', ['free', 'Origin', 'Accelerator', 'Sovereign'])->default('free');
            $table->string('assigned_trainer_id')->nullable();
            $table->string('assigned_doctor_id')->nullable();
            $table->decimal('wallet_balance', 8, 2)->default(0.00);
            $table->date('dob')->nullable();
            $table->boolean('is_active')->default(true);
            $table->decimal('credit_balance', 8, 2)->default(0.00);
            $table->json('allergies')->nullable();
            $table->timestamps();

            // $table->foreign('assigned_trainer_id')->references('trainer_id')->on('trainers')->onDelete('set null');
            // $table->foreign('assigned_doctor_id')->references('doctor_id')->on('doctors')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};