<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class Trainer extends Model
{
    use HasUuids;

    protected $primaryKey = 'trainer_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'trainer_id', 
        'user_id',
        'name',
        'email',
        'phone',
        'title',
        'description',
        'bio',
        'role',
        'calendly_url',
        'profile_photo_url_1',
        'profile_photo_url_2',
        'profile_photo_url_3',
        'specialties',
        'training_style',
        'certifications',
        'assigned_user_ids',
        'is_active'
    ];

    protected $casts = [
        'specialties' => 'array',       
        'certifications' => 'array',
        'assigned_user_ids' => 'array', 
        'is_active' => 'boolean'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'uid');
    }

    public function assignedUsers()
    {
        return $this->hasMany(User::class, 'assigned_trainer_id', 'trainer_id');
    }

    public function chats()
    {
        return $this->hasMany(Chat::class, 'trainer_id', 'trainer_id');
    }
}