<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class MealPlan extends Model
{
    use HasUuids;

    protected $fillable = [
        'user_id',
        'week_of',
        'plan_url',
        'assigned_by',
        'nutrition_focus'
    ];

    protected $casts = [
        'week_of' => 'date'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'uid');
    }
} 