<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class HealthReport extends Model
{
    use HasUuids;

    protected $primaryKey = 'report_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'report_name',
        'report_url',
        'uploaded_at',
        'uploaded_by',
        'uploader_role',
        'visibility',
        'report_type',
        'notes',
        'status',
        'expires_at',
        'tags',
        'viewed_by_user',
        'user_id'
    ];

    protected $casts = [
        'uploaded_at' => 'datetime',
        'expires_at' => 'datetime',
        'tags' => 'array',
        'viewed_by_user' => 'boolean'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'uid');
    }
}