<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class GroceryOrder extends Model
{
    use HasUuids;

    protected $primaryKey = 'order_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'user_id',
        'invoice_amount',
        'status',
        'pdf_url',
        'uploaded_by',
        'uploader_role',
        'uploaded_at',
        'user_feedback',
        'user_feedback_at',
        'user_approved',
        'user_approved_at',
        'purchased_at',
        'wallet_deducted',
        'purchase_note',
        'tags'
    ];

    protected $casts = [
        'invoice_amount' => 'decimal:2',
        'uploaded_at' => 'datetime',
        'user_feedback_at' => 'datetime',
        'user_approved_at' => 'datetime',
        'purchased_at' => 'datetime',
        'user_approved' => 'boolean',
        'wallet_deducted' => 'boolean',
        'tags' => 'json'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'uid');
    }

    public function items()
    {
        return $this->belongsToMany(GroceryItem::class, 'grocery_order_items', 'order_id', 'item_id')
            ->withPivot('quantity', 'unit_price')
            ->withTimestamps();
    }
} 