<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class GroceryItem extends Model
{
    use HasUuids;

    protected $fillable = [
        'name',
        'description',
        'price',
        'category',
        'nutritional_info'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'nutritional_info' => 'json'
    ];

    public function orders()
    {
        return $this->belongsToMany(GroceryOrder::class, 'grocery_order_items', 'item_id', 'order_id')
            ->withPivot('quantity', 'unit_price')
            ->withTimestamps();
    }
} 