<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RoleMiddleware
{
    public function handle(Request $request, Closure $next, $role)
    {
        $user = $request->user();

        if (!$user || ($user->membership_tier !== $role && !in_array($user->role, explode('|', $role)))) {
            return response()->json(['message' => 'Unauthorized'], 403);
        }

        return $next($request);
    }
}