<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class AIAgentController extends Controller
{
    
    // public function uploadPhoto(Request $request)
    // {
    //     $request->validate([
    //         'photo' => 'required|image|mimes:jpeg,png,jpg|max:2048',
    //     ]);

    //     // Simulate external AI API call (no storage)
    //     $response = Http::post('https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=AIzaSyDG0wmb4LfEYqzde395Ad4LG-vwTthP7r0', [
    //         'image' => base64_encode(file_get_contents($request->file('photo')->path())),
    //     ]);

    //     // Mock response
    //     $insights = $response->successful() ? $response->json() : [
    //         'skin_analysis' => 'Healthy skin detected',
    //         'meal_suggestion' => 'Include more leafy greens',
    //     ];

    //     return response()->json([
    //         'insights' => $insights,
    //     ]);
    // }


    public function uploadPhoto(Request $request)
{
    $request->validate([
        'photo' => 'required|image|mimes:jpeg,png,jpg|max:2048',
    ]);

    $photo = $request->file('photo');
    $base64Image = base64_encode(file_get_contents($photo->path()));
    $mimeType = $photo->getMimeType();

    $prompt = "You are a certified nutritionist AI. When a user uploads a photo of their meal, analyze the image and provide friendly, helpful feedback. Start with a Meal Summary..."; // your full prompt

    $key = env('GEMINI_API_KEY'); // better practice
$response = Http::post("https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=$key", [
    "contents" => [[
        "parts" => [
            [
                "inlineData" => [
                    "mimeType" => $mimeType,
                    "data" => $base64Image,
                ]
            ],
            [
                "text" => $prompt
            ]
        ]
    ]]
]);
   if ($response->successful()) {
    $json = $response->json();
    $insights = $json['candidates'][0]['content']['parts'][0]['text'] ?? 'No insights returned';
} else {
    $insights = 'Gemini API Error: ' . $response->status() . ' - ' . $response->body();
}


    return response()->json([
        'insights' => $insights,
    ]);
}


public function scanSkin(Request $request)
{
    $request->validate([
        'photo' => 'required|image|mimes:jpeg,png,jpg|max:2048',
    ]);

    $photo = $request->file('photo');
    $base64Image = base64_encode(file_get_contents($photo->path()));
    $mimeType = $photo->getMimeType();

    $prompt = "You are a professional dermatologist AI assistant. When a user uploads a photo of their face or skin, analyze the image and provide a helpful, friendly skin analysis. Start with a Skin Overview describing the visible skin type (e.g., oily, dry, combination, normal) and general appearance (e.g., clear, acne-prone, dull, glowing). Then provide a Condition Detection section — identify any visible issues like acne, redness, pigmentation, dark circles, fine lines, or uneven texture. Offer a Possible Cause Explanation (e.g., “Dark circles may be due to lack of sleep or dehydration”). Then give Personalized Recommendations including skincare tips, lifestyle advice, and product suggestions based on what you see. Suggest a basic AM/PM skincare routine tailored to the skin’s current state. Mention any Warning Signs (e.g., moles or spots that may need dermatologist review), if applicable. Conclude with a Motivational Skin Tip to encourage consistent care and positivity.";

    $key = env('GEMINI_API_KEY');
    $response = Http::post("https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=$key", [
        "contents" => [[
            "parts" => [
                [
                    "inlineData" => [
                        "mimeType" => $mimeType,
                        "data" => $base64Image,
                    ]
                ],
                [
                    "text" => $prompt
                ]
            ]
        ]]
    ]);

    if ($response->successful()) {
        $json = $response->json();
        $insights = $json['candidates'][0]['content']['parts'][0]['text'] ?? 'No insights returned';
    } else {
        $insights = 'Gemini API Error: ' . $response->status() . ' - ' . $response->body();
    }

    return response()->json([
        'insights' => $insights,
    ]);
}

}